<?php

// port port2
function changeChannelInfo($id)
{
   $sock = Login();

   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $index = isset($id) ? (int) $id : 0;
   $getterVideo = ParamGet($sock, "video");
   $getterAudio = ParamGet($sock, "audio");

   $audio = getAudioProperties($getterAudio, $index);
   $arr = findChannel($getterVideo->video->input, $index);

   changeUserName($object["username"], $arr, $sock, $index);

   changePassChannel($object["pass"], $arr, $sock, $index);

   changeName($object["name"], $arr, $sock, $index);

   changeTimeout($object["timeout"], $arr, $sock, $index);

   changeIp($object["ip"], $arr, $sock, $index);

   changePortRtsp($object["port_rtsp"], $arr, $sock, $index);

   changePortOnvif($object["portOnvif"], $arr, $sock, $index);

   changePortTwo($object["port2"], $arr, $sock, $index);

   changeRtsp($object["rtsp"], $arr, $sock, $index);

   changeAudio($object["audio"], $audio, $sock, $index);

   changePTZ($object["ptz"], $arr, $sock, $index);

   changeCammodel($object["cammodel"], $arr, $sock, $index);

   changeUrl($object["url1"], $arr, $sock, $index);

   changeUrlTwo($object["url2"], $arr, $sock, $index);

   if (
      (isset($object["virgin"]) && $object["virgin"]) ||
      (isset($object["secondStream"]) && $object["secondStream"] && $object["url2"] === "")
   ) {
      $mediaType = isset($object["mediaType"]) && $object["mediaType"] !== false ? $object["mediaType"] : 82;
      sleep(1);
      ParamSetInt($sock, "video.input.[" . $index . "].mediatype", intval($mediaType));
      sleep(3); // задержка от затирания данных
      ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
      ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
   } elseif (isset($object["mediaType"]) && $object["mediaType"] !== false) {
      $mediaType = $object["mediaType"];
      ParamSetInt($sock, "video.input.[" . $index . "].mediatype", intval($mediaType));
   }
}
function changeChannelName($id)
{
   $sock = Login();

   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $index = isset($id) ? (int) $id : 0;

   $arr = ParamGet($sock, "video");
   $arr = $arr->video->input;
   foreach ($arr as $item) {
      if ($item->index == $index) {
         $arr = $item;
      }
   }

   if (isset($object["name"]) && $object["name"] != "") {
      $name = $object["name"];
      if (isset($arr->title1251)) {
         if ($arr->title1251 != $name) {
            ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
            ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);
         }
      } else {
         ParamSetString($sock, "video.input.[" . $index . "].title1251", $name);
         ParamSetString($sock, "video.input.[" . $index . "].titleUtf", $name, false);
      }
   } else {
      $url = "video.input.[" . $index . "].title1251";
      if (isset($arr->title1251)) {
         ParamUnset($sock, $url);
         ParamUnset($sock, "video.input.[" . $index . "].titleUtf");
      }
   }
   generateTimeZonesForChannels($sock, $index);
}
function changeRotateImage($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $index = $object["index"];
   $imagetransformation = $object["imagetransformation"];

   $arr = ParamGet($sock, "video");
   $arr = $arr->video->input;
   foreach ($arr as $item) {
      if ($item->index == $index) {
         $arr = $item;
      }
   }

   if (isset($arr->imagetransformation)) {
      if ($arr->imagetransformation != $imagetransformation) {
         ParamSetInt($sock, "video.input.[" . $index . "].imagetransformation", $imagetransformation);
      }
   } else {
      ParamSetInt($sock, "video.input.[" . $index . "].imagetransformation", $imagetransformation);
   }
   socket_close($sock);
}
function changeState($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   $index = isset($id) ? (int) $id : 0;

   $arr = ParamGet($sock, "video");
   $arr = $arr->video->input;
   foreach ($arr as $item) {
      if ($item->index == $index) {
         $arr = $item;
      }
   }

   if (isset($object["enabled"])) {
      $enabled = $object["enabled"];
      if (isset($arr->enabled)) {
         if ($arr->enabled != $enabled) {
            ParamSetInt($sock, "video.input.[" . $index . "].enabled", $enabled);
         }
      } else {
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", $enabled);
      }
   } else {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   socket_close($sock);
}

function changeChannelGpio($id)
{
   // доделать
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);
   $index = (int) $id;
   if (!isset($index)) {
      socket_close($sock);
      return;
   }

   if (isset($object["numinpins"])) {
      $numinpins = $object["numinpins"];
      ParamSetInt($sock, "video.input.[" . $index . "].gpio.numinpins", $numinpins);
   } else {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.numinpins");
   }

   if (isset($object["numoutpins"])) {
      $numoutpins = $object["numoutpins"];
      ParamSetInt($sock, "video.input.[" . $index . "].gpio.numoutpins", $numoutpins);
   } else {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.numoutpins");
   }

   if (isset($object["inpins"])) {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.inpins.*");

      $inpins = $object["inpins"];
      $i = 0;
      foreach ($inpins as $event) {
         if (isset($event["index"])) {
            ParamSetInt(
               $sock,
               "video.input.[" . $index . "].gpio.inpins.[" . $i . "].index",
               $event["index"]
            );
         }
         if (isset($event["title1251"]) && $event["title1251"] !== "") {
            ParamSetString(
               $sock,
               "video.input.[" . $index . "].gpio.inpins.[" . $i . "].title1251",
               $event["title1251"]
            );
         } else {
            ParamUnset($sock, "video.input.[" . $index . "].gpio.inpins.[" . $i . "].title1251");
         }
         if (isset($event["token"])) {
            ParamSetInt(
               $sock,
               "video.input.[" . $index . "].gpio.inpins.[" . $i . "].token",
               $event["token"]
            );
         }
         $i += 1;
      }
   } else {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.inpins.*");
   }

   if (isset($object["outpins"])) {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.outpins.*");

      $outpins = $object["outpins"];
      $i = 0;
      foreach ($outpins as $event) {
         ParamSetInt($sock, "video.input.[" . $index . "].gpio.outpins.[" . $i . "].index", $event["index"]);

         if (isset($event["title1251"]) && $event["title1251"] !== "") {
            ParamSetString(
               $sock,
               "video.input.[" . $index . "].gpio.outpins.[" . $i . "].title1251",
               $event["title1251"]
            );
         } else {
            ParamUnset($sock, "video.input.[" . $index . "].gpio.outpins.[" . $i . "].title1251");
         }
         ParamSetInt($sock, "video.input.[" . $index . "].gpio.outpins.[" . $i . "].token", $event["token"]);
         $i += 1;
      }
   } else {
      ParamUnset($sock, "video.input.[" . $index . "].gpio.outpins.*");
   }
   socket_close($sock);
}
function changeTimeZones($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);
   if (!isset($id)) {
      socket_close($sock);
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   $index = (int) $id;
   $timezones = $object["timezones"];
   if ($timezones["key"] == "audio") {
      if ($timezones["value"]) {
         ParamSetInt(
            $sock,
            "audio.input.[" . $index . "].recorded.[" . $timezones["index"] . "]",
            intval($timezones["value"])
         );
      } else {
         ParamUnset($sock, "audio.input.[" . $index . "].recorded.[" . $timezones["index"] . "]");
      }
   } else {
      ParamSetInt(
         $sock,
         "video.input.[" . $index . "]." . $timezones["key"] . ".[" . $timezones["index"] . "]",
         intval($timezones["value"])
      );
   }
   socket_close($sock);
}
function testAuthCamera()
{
   $sock = Login();
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }

   $body = file_get_contents("php://input");
   $object = json_decode($body, true);
   $ip = $object[0]["ip"];
   $url = "http://" . $ip;
   //$url = 'http://192.168.0.182';
   $url = str_replace(" ", "%20", $url);
   $infos = pathinfo($url);

   $username = $object[0]["login"];
   $password = $object[0]["password"];
   $context = stream_context_create([
      "http" => [
         "header" => "Authorization: Basic " . base64_encode("$username:$password"),
      ],
   ]);

   // $data = file_get_contents($url, true, $context);

   // echo $data;
   socket_close($sock);
   return 1;
}
function multiSaveChannels()
{
   $sock = Login();

   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   $array = $object["list"];

   $getterVideo = ParamGet($sock, "video");
   $getterAudio = ParamGet($sock, "audio");

   $restartArray = [];
   $isChangeParamsForReconnect = false;

   foreach ($array as $index) {
      $isChangeParamsForReconnect = false;
      $channel = findChannel($getterVideo->video->input, $index);

      $isChangeParamsForReconnect = changePassChannel(
         $object["password"],
         $channel,
         $sock,
         $index,
         $isChangeParamsForReconnect
      );

      $isChangeParamsForReconnect = changeUserName(
         $object["username"],
         $channel,
         $sock,
         $index,
         $isChangeParamsForReconnect
      );

      $isChangeParamsForReconnect = changeIp(
         $object["ip"],
         $channel,
         $sock,
         $index,
         $isChangeParamsForReconnect
      );

      if (isset($object["port_rtsp"])) {
         array_push($restartArray, $index);
         changePortRtsp($object["port_rtsp"], $channel, $sock, $index);
      }

      if (isset($object["port2"])) {
         array_push($restartArray, $index);
         changePortTwo($object["port2"], $channel, $sock, $index);
      }
      changePortOnvif($object["portOnvif"], $channel, $sock, $index);

      $audio = getAudioProperties($getterAudio, $index);
      changeAudio($object["sound"], $audio, $sock, $index);

      changeUrl($object["url"], $channel, $sock, $index);

      changeUrlTwo($object["url2"], $channel, $sock, $index);

      if (isset($object["stream2"]) && $object["stream2"] == false) {
         ParamUnset($sock, "video.input.[" . $index . "].url2");
      }

      changeTimeout($object["timeout"], $channel, $sock, $index);

      changePTZ($object["ptz"], $channel, $sock, $index);

      if (isset($object["timezones"])) {
         $timezones = $object["timezones"];
         $audio = [];
         foreach ($timezones as $timezone) {
            if (isset($timezone["va_rec"])) {
               ParamSetInt(
                  $sock,
                  "video.input.[" . $index . "].va_rec.[" . $timezone["index"] . "]",
                  intval($timezone["va_rec"])
               );
            }

            if (isset($timezone["audio"])) {
               if ($timezone["audio"]) {
                  ParamSetInt(
                     $sock,
                     "audio.input.[" . $index . "].recorded.[" . $timezone["index"] . "]",
                     intval($timezone["audio"])
                  );
               } else {
                  ParamUnset($sock, "audio.input.[" . $index . "].recorded.[" . $timezone["index"] . "]");
               }
            }

            if (isset($timezone["alarmdelay"])) {
               ParamSetInt(
                  $sock,
                  "video.input.[" . $index . "].alarmdelay.[" . $timezone["index"] . "]",
                  intval($timezone["alarmdelay"])
               );
            }

            if (isset($timezone["prevrectime"])) {
               ParamSetInt(
                  $sock,
                  "video.input.[" . $index . "].prevrectime.[" . $timezone["index"] . "]",
                  intval($timezone["prevrectime"])
               );
            }

            if (isset($timezone["detskip"])) {
               ParamSetInt(
                  $sock,
                  "video.input.[" . $index . "].detskip.[" . $timezone["index"] . "]",
                  intval($timezone["detskip"])
               );
            }

            if (isset($timezone["motionskip"])) {
               ParamSetInt(
                  $sock,
                  "video.input.[" . $index . "].motionskip.[" . $timezone["index"] . "]",
                  intval($timezone["motionskip"])
               );
            }
         }
      }
      changeRtsp($object["rtsp"], $channel, $sock, $index);

      changeCammodel($object["cammodel"], $channel, $sock, $index);

      if ($isChangeParamsForReconnect) {
         $key = array_search($index, $restartArray);
         if ($key === false) {
            array_push($restartArray, $index);
         }
         $mediaType =
            isset($object["mediaType"]) && $object["mediaType"] !== false ? $object["mediaType"] : 82;

         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 0);
         ParamSetInt($sock, "video.input.[" . $index . "].mediatype", intval($mediaType));
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp", 1);
         ParamSetInt($sock, "video.input.[" . $index . "].usetcp2", 1);
      }

      if (isset($object["enabled"])) {
         $enabled = $object["enabled"];
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", intval($enabled));
      }
   }

   if ($isChangeParamsForReconnect) {
      sleep(3); // задержка от затирания данных
   }

   foreach ($restartArray as $index) {
      ParamSetInt($sock, "video.input.[" . $index . "].enabled", 1);
   }

   socket_close($sock);
}
function multiResetCameras()
{
   $list = json_decode(file_get_contents("php://input"), true);

   if (!isset($list) || count($list) <= 0) {
      header("HTTP/1.1 400 Bad Request");
      die();
      return;
   }

   $sock = Login();
   checkActionAccess($sock, "write");

   $array = [
      "title1251",
      "ip",
      "portOnvif",
      "username",
      "cam_password",
      "port",
      "port2",
      "url",
      "url2",
      "mediatype",
      "ptz",
      "cammodel",
      "portHttp",
      "onvifProfileToken",
   ];

   foreach ($list as $index) {
      foreach ($array as $item) {
         ParamUnset($sock, "video.input.[" . $index . "]." . $item);
      }
      ParamSetInt($sock, "video.input.[" . $index . "].enabled", 0);
   }
   socket_close($sock);
}
function changeIntegrationOptions($id)
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $options = json_decode(file_get_contents("php://input"), true);

   $array = ["ivibrmoid", "geolat", "geolon", "titleshort", "homeaddress", "districtName", "cameraTypeName"];
   foreach ($array as $key) {
      if (isset($options[$key])) {
         if ($options[$key] !== "") {
            ParamSetString($sock, "video.input.[" . $id . "]." . $key, $options[$key], false);
         } else {
            ParamUnset($sock, "video.input.[" . $id . "]." . $key);
         }
      }
   }
   socket_close($sock);
}
function changeIntegrationOptionsMulti()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $optionsArray = json_decode(file_get_contents("php://input"), true);

   $array = ["ivibrmoid", "geolat", "geolon", "titleshort", "homeaddress", "districtName", "cameraTypeName"];
   foreach ($optionsArray["cameras"] as $index) {
      foreach ($array as $key) {
         if (isset($optionsArray["settings"][$key])) {
            if ($optionsArray["settings"][$key] !== "" && $optionsArray["settings"][$key] !== null) {
               ParamSetString(
                  $sock,
                  "video.input.[" . $index . "]." . $key,
                  $optionsArray["settings"][$key],
                  false
               );
            } else {
               ParamUnset($sock, "video.input.[" . $index . "]." . $key);
            }
         }
      }
   }
   socket_close($sock);
}
function changeGroup()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   $index = $object["index"];

   $getterVideo = ParamGet($sock, "video");

   $channel = findChannel($getterVideo->video->input, $index);

   changeLocation1251($object["location1251"], $channel, $sock, $index);

   socket_close($sock);
}
function changeChainCamera()
{
   $sock = Login();

   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   ParamSetString($sock, "video.input.[" . $object["index"] . "].ptz.onviftourtoken", $object["token"]);
}
function generateTimeZonesForChannels($sock, $index)
{
   $arr = ParamGet($sock, "audio");
   $arr = $arr->audio->input;
   foreach ($arr as $item) {
      if ($item->index == $index) {
         $arr = $item;
      }
   }
   echo json_encode($arr);
}
